% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{bekk_fit}
\alias{bekk_fit}
\title{BEKK fit}
\usage{
bekk_fit(r_t, model = "sBEKK", R = 100, out_of_sample = NULL)
}
\arguments{
\item{r_t}{List of daily returns. At the moment, at most 5 assets can be considered}

\item{model}{Valid choices are: 'sBEKK'(scalar BEKK) and 'dBEKK' (diagonal BEKK)}

\item{R}{\strong{optional} Number of random samples drawn from a Uniform distribution used
to inizialize the log-likelihood. Equal to 100 by default}

\item{out_of_sample}{\strong{optional} A positive integer indicating the number of periods before the last to keep for out of sample forecasting}
}
\value{
\code{bekk_fit} returns a list containing the following components:
\itemize{
\item assets: Names of the assets considered.
\item mat_coef: Matrix of estimated coefficients of the model, with the QML standard errors.
\item obs: The number of daily observations used for the estimation.
\item period: The period of the estimation.
\item H_t: Conditional covariance matrix, reported as an array. It refers to the in-sample
period.
\item est_time: Time of estimation.
\item llk: The value of the log-likelihood at the maximum.
\item H_t_oos: Conditional covariance matrix, reported as an array, for the out-of-sample period,
if the param 'out_of_sample' is used.
\item Days: Days of the (in-)sample period.
}
}
\description{
Obtains the estimation the scalar and diagonal BEKK model
}
\details{
Function \code{bekk_fit} implements the estimation of scalar and diagonal BEKK models. For details on BEKK models, see \insertCite{engle1995multivariate;textual}{dccmidas}
}
\examples{
\donttest{
require(xts)
# close to close daily log-returns
r_t_s<-diff(log(sp500['2010/2019'][,3]))
r_t_s[1]<-0
r_t_n<-diff(log(nasdaq['2010/2019'][,3]))
r_t_n[1]<-0
r_t_f<-diff(log(ftse100['2010/2019'][,3]))
r_t_f[1]<-0
db_m<-merge.xts(r_t_s,r_t_n,r_t_f)
db_m<-db_m[complete.cases(db_m),]
colnames(db_m)<-c("S&P500","NASDAQ","FTSE100")
# list of returns
r_t<-list(db_m[,1],db_m[,2],db_m[,3])
bekk_est<-bekk_fit(r_t,model="sBEKK")
bekk_est$mat_coef
}
}
\references{
\insertAllCited{}
}
