% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.ob_decompose}
\alias{plot.ob_decompose}
\title{Plot decomposition terms for quantiles}
\usage{
\method{plot}{ob_decompose}(
  x,
  ...,
  detailed_effects = TRUE,
  aggregate_factors = TRUE,
  custom_aggregation = NULL,
  confidence_bands = FALSE,
  confidence_level = 0.95
)
}
\arguments{
\item{x}{an object of class "ob_decompose", usually, a result of a call to [ob_decompose()] with [statistics = "quantiles"].}

\item{...}{other parameters to be passed through to plot function.}

\item{detailed_effects}{If `TRUE` (default), then the detailed effects are plotted. Otherwise only the total (aggregate) effects are plotted.}

\item{aggregate_factors}{boolean, if `TRUE` (default) terms associated with detailed factor
levels are aggregated to a single term for every factor variable.}

\item{custom_aggregation}{list specifying the aggregation of detailed decomposition
terms. The parameter `custom_aggregation` overrides the parameter `aggregate_factors`.
If `NULL` (default), then either all detailed terms or all terms associated with
a single variable are returned.}

\item{confidence_bands}{If `TRUE` and if standard errors have been bootstrapped, confidence bands are plotted.}

\item{confidence_level}{numeric value between 0 and 1 (default = 0.95) that defines the confidence interval
plotted as a ribbon and defined as \code{qnorm((1-confidence_level)/2)} * standard error.}
}
\value{
a ggplot illustrating the decomposition terms for quantiles.
}
\description{
The function plots decomposition terms for quantiles estimtated
with \code{ob_decompose} over the  unit interval.
}
\examples{
data("nlys00")

mod1 <- log(wage) ~ age + central_city + msa + region + black +
  hispanic + education + afqt + family_responsibility + years_worked_civilian +
  years_worked_military + part_time + industry

# plotting RIF regression decomposition of deciles
\donttest{
decompose_rifreg_deciles <- ob_decompose(
  formula = mod1,
  data = nlys00,
  group = female,
  reweighting = TRUE,
  rifreg_statistic = "quantiles",
  bootstrap = TRUE,
  bootstrap_iterations = 50,
  reference_0 = FALSE
)

plot(decompose_rifreg_deciles)

plot(decompose_rifreg_deciles,
  confidence_bands = TRUE
)
}

# plotting Oaxaca-Blinder decomposition

decompose_ob_mean <- ob_decompose(
  formula = mod1,
  data = nlys00,
  group = female,
  reweighting = TRUE,
  bootstrap = FALSE,
  reference_0 = FALSE
)

plot(decompose_ob_mean)
plot(decompose_ob_mean, detailed_effects = FALSE)


# With custom aggregation

custom_aggregation <- list(
  `Age, race, region, etc.` = c(
    "age",
    "blackyes",
    "hispanicyes",
    "regionNorth-central",
    "regionSouth",
    "regionWest",
    "central_cityyes",
    "msayes"
  ),
  `Education` = c(
    "education<10 yrs",
    "educationHS grad (diploma)",
    "educationHS grad (GED)",
    "educationSome college",
    "educationBA or equiv. degree",
    "educationMA or equiv. degree",
    "educationPh.D or prof. degree"
  ),
  `AFTQ` = "afqt",
  `L.T. withdrawal due to family` = "family_responsibility",
  `Life-time work experience` = c(
    "years_worked_civilian",
    "years_worked_military",
    "part_time"
  ),
  `Industrial sectors` = c(
    "industryManufacturing",
    "industryEducation, Health, Public Admin.",
    "industryOther services"
  )
)

plot(decompose_ob_mean, custom_aggregation = custom_aggregation)

}
