% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.r
\name{write_fastq}
\alias{write_fastq}
\alias{write_fastq.DNAseq}
\title{Output the denoised sequence to a fastq format with placeholder phred scores.}
\usage{
write_fastq(x, ...)

\method{write_fastq}{DNAseq}(x, ..., outfile = "denoised.fastq",
  append = TRUE, keep_phred = TRUE, phred_placeholder = "#")
}
\arguments{
\item{x}{a DNAseq class object.}

\item{...}{additional arguments to be passed between methods.}

\item{outfile}{The name of the file to output the data to. Default is "denoised.fasta".}

\item{append}{Should the ccs consensus sequence be appended to the output file?(TRUE) 
Or overwrite the file?(FALSE) Default is TRUE.}

\item{keep_phred}{Should the original PHRED scores be kept in the output? Default is TRUE.}

\item{phred_placeholder}{The character to input for the phred score line. Default is '#'.}
}
\value{
a class object of code "DNAseq"
}
\description{
Output the denoised sequence to a fastq format with placeholder phred scores.
}
\seealso{
\code{\link{DNAseq}}

\code{\link{frame}}

\code{\link{adjust}}
}
