% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TTE_pipeline.R
\name{TTE_pipeline}
\alias{TTE_pipeline}
\title{Target Trial Emulation (TTE) Pipeline}
\usage{
TTE_pipeline(data, xvars, yvars, ncovars = NULL, ps_type, outcome_measure)
}
\arguments{
\item{data}{A dataset containing treatment assignment, covariates, and outcomes.}

\item{xvars}{A character vector of covariate names used for propensity score estimation.}

\item{yvars}{A character vector of primary outcome variable names.}

\item{ncovars}{Optional. A character vector of negative control outcome variable names.}

\item{ps_type}{The propensity score method: "Matching", "Stratification", or "Weighting".}

\item{outcome_measure}{The outcome measure to estimate: "RR" (Risk Ratio), "OR" (Odds Ratio), or "HR" (Hazard Ratio).}
}
\value{
An object of class "TTE" containing the propensity score analysis results
}
\description{
Implements a Target Trial Emulation pipeline using propensity score methods, including matching, weighting, and stratification.
}
\examples{
library("dplyr")
data(demo_data)
xvars <- c("eth_cat", "age_cat", "sex", "cohort_entry_month",
            "obese", "pmca_index", "n_ed", "n_inpatient",
           "n_tests", "imm_date_diff_grp", "medical_1", "medical_2",
           "medical_3", "medical_4", "medical_5")
yvars1 <- colnames(demo_data \%>\% select(starts_with("visits_")))
yvars2 <- colnames(demo_data \%>\% select(starts_with("event_")))
# without negative controls
TTE_pipeline(demo_data, xvars=xvars, yvars=yvars1, ps_type="Matching", outcome_measure="RR")
# with negative controls
ncovars1 <- colnames(demo_data \%>\% select(starts_with("nco_visits_")))
TTE_pipeline(
  demo_data,
  xvars = xvars,
  yvars = yvars1,
  ncovars = ncovars1,
  ps_type = "Matching",
  outcome_measure = "RR"
)
}
