% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{text}
\alias{text}
\alias{deb_text}
\alias{deb_text.default}
\alias{deb_text.deb_lsd}
\alias{deb_text.deb_decimal}
\alias{deb_text.deb_tetra}
\title{Format \code{deb_lsd}, \code{deb_decimal}, and \code{deb_tetra} vectors as text}
\usage{
deb_text(x, ...)

\method{deb_text}{default}(x, ...)

\method{deb_text}{deb_lsd}(
  x,
  digits = 0,
  currency = "£",
  l.mark = "",
  s.mark = "s.",
  d.mark = "d.",
  sep = " ",
  big.mark = ",",
  decimal.mark = ".",
  suffix = "",
  ...
)

\method{deb_text}{deb_decimal}(
  x,
  digits = 0,
  currency = "£",
  big.mark = ",",
  decimal.mark = ".",
  suffix = "",
  ...
)

\method{deb_text}{deb_tetra}(
  x,
  digits = 0,
  currency = "£",
  l.mark = "",
  s.mark = "s.",
  d.mark = "d.",
  f.mark = "f.",
  sep = " ",
  big.mark = ",",
  decimal.mark = ".",
  suffix = "",
  ...
)
}
\arguments{
\item{x}{A vector of class \code{deb_lsd}, \code{deb_decimal}, or \code{deb_tetra}.}

\item{...}{Arguments passed on to further methods.}

\item{digits}{Desired number of digits after the decimal mark to which to
round the numeric values. Default is \code{0}.}

\item{currency}{Character used for the currency mark. Default is pound sign.}

\item{l.mark}{Character used following the pounds (l) unit.
Default is \code{""}.}

\item{s.mark}{Character used following the shillings (s) unit.
Default is \code{"s."}.}

\item{d.mark}{Character used following the pence (d) unit.
Default is \code{"d."}.}

\item{sep}{Character to separate pounds, shillings, pence, and optionally
farthing units. Default is \code{" "}.}

\item{big.mark}{Character used to mark intervals to the left of the decimal
mark. Default is \code{","} with default \code{big.interval} of \code{3}.}

\item{decimal.mark}{Character used for decimal mark. Default is \code{"."}.}

\item{suffix}{Character placed after the values. Default is \code{""}.}

\item{f.mark}{Character used following the farthing (f) unit with
tetrapartite values. Default is \code{"f."}.}
}
\value{
A Character vector of formatted values.
}
\description{
Flexible way to format \code{deb_lsd}, \code{deb_decimal}, and \code{deb_tetra} vectors
for use as labels or text.
}
\details{
\code{deb_text} is similar to \code{as.character()} in that both return a character
vector of the values of \code{deb_lsd}, \code{deb_decimal}, and \code{deb_tetra} vectors.
However, \code{as.character()} uses the normal printing method for these vectors.
\code{deb_text()} provides a convenient way to nicely format \code{deb_lsd},
\code{deb_decimal}, and \code{deb_tetra} vectors for use as text or labels with
options for customization.

\code{deb_text()} uses \code{formatC()} to format the numeric values of \code{x}. Numbers
are printed in non-scientific format and trailing zeros are dropped.

All character vector arguments should be length 1.
}
\examples{
lsd <- deb_lsd(l = c(10000, 0, -10000),
               s = c(8, 0, -8),
               d = c(5.8252, 0, -5.8252))
dec <- deb_decimal(c(10000.8252, 0, -10000.8252))
tetra <- deb_tetra(l = c(10000, 0, -10000),
                   s = c(8, 0, -8),
                   d = c(5, 0, -5),
                   f = c(2.8252, 0, -2.8252))

deb_text(lsd)
deb_text(dec)
deb_text(tetra)

# Compact format for deb_lsd with suffix to distinguish currency
deb_text(lsd, s.mark = "", d.mark = "",
         sep = ".", suffix = " Flemish")

# Control the number of digits
deb_text(lsd, digits = 3)
deb_text(dec, digits = 3)
deb_text(tetra, digits = 3)

# Change big mark and decimal mark
deb_text(lsd, digits = 4, big.mark = ".", decimal.mark = ",")
deb_text(dec, digits = 4, big.mark = ".", decimal.mark = ",")
deb_text(tetra, digits = 4, big.mark = ".", decimal.mark = ",")

}
\seealso{
\code{\link[=formatC]{formatC()}} for further options passed to \code{...}.
}
