% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_heatmap-layer.R
\name{add_heatmap_layer}
\alias{add_heatmap_layer}
\title{Add a heatmap layer to the deckgl widget}
\usage{
add_heatmap_layer(
  deckgl,
  id = "heatmap-layer",
  data = NULL,
  properties = list(),
  ...
)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{id}{The unique id of the layer.}

\item{data}{The url to fetch data from or a data object.}

\item{properties}{A named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class. The \code{properties} parameter can also be an empty list. In this case
all props must be passed as named arguments.}

\item{...}{Named arguments that will be added to the \code{properties} object. Identical parameters
are overwritten.}
}
\description{
The \code{HeatmapLayer} can be used to visualize spatial distribution of data.
It internally implements Gaussian Kernel Density Estimation to render heatmaps.
}
\examples{
## @knitr heatmap-layer
data("sf_bike_parking")

map <- deckgl() \%>\%
  add_heatmap_layer(
    data = sf_bike_parking,
    getPosition = ~lng + lat,
    getWeight = ~spaces
  ) \%>\%
  add_basemap()

if (interactive()) map
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/heatmap-layer}
}
