% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_hexagon-layer.R
\name{add_hexagon_layer}
\alias{add_hexagon_layer}
\title{Add a hexagon layer to the deckgl widget}
\usage{
add_hexagon_layer(
  deckgl,
  data = NULL,
  properties = list(),
  ...,
  id = "hexagon-layer"
)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{data}{The url to fetch data from or a data object.}

\item{properties}{A named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class. The \code{properties} parameter can also be an empty list. In this case
all props must be passed as named arguments.}

\item{...}{Named arguments that will be added to the \code{properties} object. Identical parameters
are overwritten.}

\item{id}{The unique id of the layer.}
}
\description{
The \code{HexagonLayer} renders a hexagon heatmap based on an array of points. It takes the radius of hexagon bin, projects points into hexagon bins.
The color and height of the hexagon is scaled by number of points it contains.
}
\examples{
## @knitr hexagon-layer
data("sf_bike_parking")

properties <- list(
  extruded = TRUE,
  radius = 200,
  elevationScale = 4,
  getPosition = ~lng + lat,
  colorRange = RColorBrewer::brewer.pal(6, "Oranges"),
  tooltip = "
    <p>{{position.0}}, {{position.1}}<p>
    <p>Count: {{points.length}}</p>
    <p>{{#points}}<div>{{address}}</div>{{/points}}</p>
  ",
  onClick = JS("obj => console.log(obj)"),
  autoHighlight = TRUE
)

deck <- deckgl(zoom = 11, pitch = 45, bearing = 35) \%>\%
  add_hexagon_layer(data = sf_bike_parking, properties = properties) \%>\%
  add_control("Hexagon Layer", "top-left") \%>\%
  add_basemap()

if (interactive()) deck
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/hexagon-layer}
}
