% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_eclairs.R
\name{lm_each_eclairs}
\alias{lm_each_eclairs}
\title{Fit linear model on each feature after decorrelating}
\usage{
lm_each_eclairs(
  formula,
  data,
  X,
  ecl,
  subset,
  weights,
  na.action,
  method = "qr",
  model = TRUE,
  x = FALSE,
  y = FALSE,
  qr = TRUE,
  singular.ok = TRUE,
  contrasts = NULL,
  offset,
  ...
)
}
\arguments{
\item{formula}{an object of class 'formula' (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{a matrix or data.frame containing the variables in the model}

\item{X}{matrix or data.frame where each column stores a predictor to be evaluated by the regression model one at a time.  The \eqn{i^{th}} model includes \code{X[,i]} as a predictor.}

\item{ecl}{estimate of covariance/correlation matrix from \link{eclairs} storing \eqn{U}, \eqn{d_1^2}, \eqn{\lambda} and \eqn{\nu}}

\item{subset}{same as for \link{lm}}

\item{weights}{same as for \link{lm}}

\item{na.action}{same as for \link{lm}}

\item{method}{same as for \link{lm}}

\item{model}{same as for \link{lm}}

\item{x}{same as for \link{lm}}

\item{y}{same as for \link{lm}}

\item{qr}{same as for \link{lm}}

\item{singular.ok}{same as for \link{lm}}

\item{contrasts}{same as for \link{lm}}

\item{offset}{same as for \link{lm}}

\item{...}{other arguments passed to \code{lm()}}
}
\value{
data.frame with columns \code{beta}, \code{se}, \code{tsat}, \code{pvalue} storing results for regression model fit for each feature
}
\description{
Fit linear model on each feature after applying decorrelation projection to response and predictors.
}
\examples{
library(Rfast)

n <- 800 # number of samples
p <- 200 # number of features

# create correlation matrix
Sigma <- autocorr.mat(p, .9)

# draw data from correlation matrix Sigma
Y <- rmvnorm(n, rep(0, p), sigma = Sigma * 5.1, seed = 1)

# eclairs decomposition
ecl <- eclairs(Y)

# simulate covariates
data <- data.frame(matrnorm(p, 2, seed = 1))
colnames(data) <- paste0("v", 1:2)

# simulate response
y <- rnorm(p)

# Simulate 1000 features to test
X <- matrnorm(p, 1000, seed = 1)
colnames(X) <- paste0("set_", seq(ncol(X)))

# Use linear model to test each feature stored as columns in X
res <- lm_each_eclairs(y ~ v1 + v2, data, X, ecl)

head(res)

# Analysis after non-linear transform
#------------------------------------

# Apply function to transforme data
f <- function(x) log(x^2 + 0.001)

# evaluate covariance of transformed data
ecl_transform <- cov_transform(ecl, f, 100)

# Use linear model to test each feature stored as columns in X
# in data transformed by f()
res2 <- lm_each_eclairs(f(y) ~ v1 + v2, data, X, ecl_transform)

head(res)

}
