% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neural-nets.R
\docType{class}
\name{NeuralNetwork-class}
\alias{NeuralNetwork-class}
\alias{neuralNet}
\title{The main NeuralNetwork class, that holds the layers.}
\description{
The main NeuralNetwork class, that holds the layers.
}
\section{Fields}{

\describe{
\item{\code{eta}}{The learning tax, representes the size of the weight adjustment
between each epoch of training.}

\item{\code{layers}}{This field is a list of the layers of the network, you can use
subsetting to inspect them.}
}}


\examples{
# Create a dataset
dataset <- iris
dataset$Petal.Length <- NULL
dataset$Petal.Width <- NULL
dataset <- dataset[dataset$Species != "versicolor",]
dataset$Code <- as.integer(dataset$Species == "virginica")
dataset <- dataset[sample(20),]

# Create the network
net <- neuralNet(2, perceptronLayer(1))

# Train the network, takes a while
net$train(dataset[,c(1,2), drop=FALSE], dataset[,'Code', drop=FALSE], epochs = 10)

# Check the output
net$compute(c(1,2))

# See accuracy
net$validationScore(dataset[,c(1,2), drop=FALSE], dataset[,'Code', drop=FALSE])

}
