% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_glossary.R
\name{create_glossary}
\alias{create_glossary}
\title{Create a Glossary with the DeepL API Pro}
\usage{
create_glossary(
  name,
  source_lang,
  target_lang,
  entries_source_lang,
  entries_target_lang,
  return_tibble = F,
  auth_key
)
}
\arguments{
\item{name}{A string specifying the name to be associated with the glossary.}

\item{source_lang}{A string specifying the source language code.}

\item{target_lang}{A string specifying the target language code.}

\item{entries_source_lang}{A character vector containing the glossary entries in the source language.}

\item{entries_target_lang}{A character vector containing the glossary entries in the target language.}

\item{return_tibble}{Logical. If \code{TRUE}, the returned result will be converted to a tibble.}

\item{auth_key}{A string representing the authentication key for the DeepL API Pro. 
If not provided, the function will attempt to retrieve the key from the environment 
variable \code{DEEPL_API_KEY}. You can set this variable using 
\code{Sys.setenv(DEEPL_API_KEY = "your_key")} or define it in your \code{.Renviron} 
file for persistent use.}
}
\description{
\code{create_glossary} creates a glossary for a language pair using the DeepL API Pro.
}
\details{
To use this function, you must obtain an authentication key by registering for a DeepL API Pro account at 
    \href{https://www.deepl.com/pro#developer}{DeepL API Pro}. The function sends a request to create a glossary 
    and returns the result in a structured format.
}
\examples{
\dontrun{
glossary_english <- c("Hello", "Goodbye")
glossary_swiss_german <- c("Grüezi", "Adiöö")
 
create_glossary(
  name = "My Glossary",
  source_lang = "en",
  target_lang = "de",
  entries_source_lang = glossary_english,
  entries_target_lang = glossary_swiss_german
)
}

}
\references{
\href{https://developers.deepl.com/docs/api-reference/glossaries}{DeepL API Documentation on Glossaries}
}
