% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/usage.R
\name{usage}
\alias{usage}
\title{Retrieve Usage Data from a DeepL API Pro Account}
\usage{
usage(auth_key)
}
\arguments{
\item{auth_key}{Character. Your DeepL API authentication key. If missing, the function uses 
the \code{DEEPL_API_KEY} environment variable. You can set it using 
\code{Sys.setenv(DEEPL_API_KEY = "your_key")} or define it in your \code{.Renviron} file for persistent use.}
}
\value{
A named list or structured object containing:
\itemize{
  \item \code{character_count} – Number of characters used in the current billing period.
  \item \code{character_limit} – Total character limit for the current billing period.
}
}
\description{
\code{usage} returns the character usage and configured character limit for the current billing period
    of a DeepL API Pro account.
}
\details{
To use this function, you must register for a DeepL API Pro account at 
\url{https://www.deepl.com/pro#developer}.
}
\examples{
\dontrun{
usage()
}

}
\references{
\href{https://developers.deepl.com/docs/api-reference/usage-and-quota}{DeepL API Documentation — Usage}
}
