% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qdegross.R
\name{qdegross}
\alias{qdegross}
\title{Quantile function based on an object resulting from the estimation procedure in \link{degross}.}
\usage{
qdegross(p, degross.fit, phi, get.se=FALSE, cred.level=.95, eps=1e-4)
}
\arguments{
\item{p}{Scalar or vector of probabilities in (0,1) indicating the requested fitted quantiles Q(p) based on the density estimation results in \code{degross.fit}.}

\item{degross.fit}{A \code{\link{degross.object}} generated using \link{degross} and containing the density estimation results.}

\item{phi}{(Optional) vector of spline parameters for the log density (default: \code{degross.fit$phi} if missing).}

\item{get.se}{Logical indicating if standard errors for Q(p) are requested (default: FALSE).}

\item{cred.level}{Level of credible intervals for Q(p).}

\item{eps}{Precision with which each quantile should be computed (default: 1e-4).}
}
\value{
A scalar or vector \code{x} of the same length as \code{p} containing the values Q(p) at which the cdf \code{pdegross(x,degross.fit)} is equal to \code{p}.
When \code{get.se} is TRUE, a vector or a matrix containing the quantile estimate(s), standard errors and credible interval limits for Q(p) is provided.
}
\description{
Quantile function based on an object resulting from the estimation procedure in \link{degross}.
}
\examples{
## Generate grouped data
sim = simDegrossData(n=3500, plotting=TRUE, choice=2)

## Create a degrossData object
obj.data = degrossData(Big.bins=sim$Big.bins, freq.j=sim$freq.j, m.j=sim$m.j)
print(obj.data)

## Estimate the density
obj.fit = degross(obj.data)

## Corresponding fitted quantiles
p = c(.01,.05,seq(.1,.9,by=.1),.95,.99) ## Desired probabilities
Q.p = qdegross(p,obj.fit) ## Compute the desired quantiles
print(Q.p) ## Estimated quantiles

## Compute the standard error and a 90\% credible interval for the 60\% quantile
Q.60 = qdegross(.60,obj.fit,get.se=TRUE,cred.level=.90) ## Compute the desired quantile
print(Q.60) ## Estimated quantile, standard error and credible interval

}
\references{
Lambert, P. (2021) Moment-based density and risk estimation from grouped summary statistics. arXiv:2107.03883.
}
\seealso{
\code{\link{degross.object}}, \code{\link{ddegross}}, \code{\link{pdegross}}, \code{\link{degross}}.
}
\author{
Philippe Lambert \email{p.lambert@uliege.be}
}
