% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{add_perturb}
\alias{add_perturb}
\title{De-identification via random noise}
\usage{
add_perturb(object, ..., noise = adaptive_noise(0.1))
}
\arguments{
\item{object}{Either a \code{data.frame}, \code{tibble}, or existing \code{DeidentList} pipeline.}

\item{...}{variables to be transformed.}

\item{noise}{a single-argument function that applies randomness.}
}
\value{
A 'DeidentList' representing the untrained transformation pipeline.
The object contains fields:
\itemize{
\item \code{deident_methods} a list of each step in the pipeline (consisting of \code{variables} and \code{method})
}

and methods:
\itemize{
\item \code{mutate} apply the pipeline to a new data set
\item \code{to_yaml} serialize the pipeline to a '.yml' file
}
}
\description{
\code{add_perturb()} adds an perturbation step to a transformation pipeline
(NB: intended for numeric data).  When ran as a transformation, each
specified variable is transformed by the \code{noise} function.
}
\examples{

pipe.perturb <- add_perturb(ShiftsWorked, `Daily Pay`)
pipe.perturb$mutate(ShiftsWorked)

pipe.perturb.white_noise <- add_perturb(ShiftsWorked, `Daily Pay`, noise=white_noise(0.1))
pipe.perturb.white_noise$mutate(ShiftsWorked)

pipe.perturb.noisy_adaptive <- add_perturb(ShiftsWorked, `Daily Pay`, noise=adaptive_noise(1))
pipe.perturb.noisy_adaptive$mutate(ShiftsWorked)
}
\seealso{
\code{\link[=adaptive_noise]{adaptive_noise()}}, \code{\link[=white_noise]{white_noise()}}, and \code{\link[=lognorm_noise]{lognorm_noise()}}
}
\keyword{API}
