% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImputeSim.R
\name{GetImputedDataSet}
\alias{GetImputedDataSet}
\title{Output a single imputed data set}
\usage{
GetImputedDataSet(imputeSim, index)
}
\arguments{
\item{imputeSim}{A \code{ImputeSim} object which contains 
multiple imputed data sets}

\item{index}{numeric, which of the multiple imputed data sets to output}
}
\value{
A \code{SingleSim} object with \code{status="imputed"}
}
\description{
Output a single imputed data set
}
\examples{
sim <- SimulateComplete(study.time=365,number.subjects=50,
event.rates=c(0.01,0.005),dispersions=0.25)
sim.with.MCAR.dropout <- SimulateDropout(sim,
  drop.mechanism = ConstantRateDrop(rate = 0.0025))
fit <- Simfit(sim.with.MCAR.dropout)
imps <- Impute(fit, copy_reference(), 10)
imp1 <- GetImputedDataSet(imps, 1)

}
\seealso{
\code{\link{ImputeSim.object}}
}
