% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_md.R
\name{write_md}
\alias{write_md}
\title{Write a markdown-formatted metadata document}
\usage{
write_md(x, file)
}
\arguments{
\item{x}{Object of any class handled by \code{delma}; i.e. \verb{tbl_lp,} \code{tbl_df},
\code{list} or \code{xml_document}.}

\item{file}{Filename to write to. Must be either \code{.md}, \code{.Rmd}
or \code{.qmd} file.}
}
\value{
Doesn't return anything; called for the side-effect of writing the
specified markdown file to disk.
}
\description{
\code{write_md()} creates an \code{Rmd} or \code{Qmd} file from an EML file.
}
\details{
Similar to \code{\link[=read_md]{read_md()}}, \code{\link[=write_md]{write_md()}} is considerably less generic than most
\code{write_} functions. If \code{x} is an \code{xml_document} this should convert seamlessly;
but lists or tibbles that have been manually formatted require care.
Internally, \code{write_md()} calls \link[lightparser:combine_tbl_to_file]{lightparser::combine_tbl_to_file}.
}
\examples{
\dontshow{
.old_wd <- setwd(tempdir())
}
source_file <- system.file("extdata", 
                           "bionet_metadata.xml",
                           package = "delma")
df <- read_eml(source_file)
write_md(df, "example.Rmd")
\dontshow{
setwd(.old_wd)
}
}
