% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{dweibull3}
\alias{dweibull3}
\alias{pweibull3}
\alias{qweibull3}
\alias{rweibull3}
\title{The three-parameter Weibull Distribution}
\usage{
dweibull3(x, shape, scale = 1, loc = 0, log = FALSE)
pweibull3(q, shape, scale, loc = 0, lower.tail = TRUE, log.p = FALSE)
qweibull3(p, shape, scale, loc = 0, lower.tail = TRUE, log.p = FALSE)
rweibull3(n, shape, scale = 1, loc = 0)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{shape, scale, loc}{shape, scale and location parameters. The two latter
default to  \code{1} and \code{0} respectively.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities \code{p} are given as
\code{log(p)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is
taken to be the number required.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}
}
\description{
Density, distribution function, quantile function and random generation for
the three-parameter Weibull.
}
\seealso{
\code{\link[stats]{dweibull}} for the Weibull distribution.
}
