% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dep_rank.R
\name{dep_percentiles}
\alias{dep_percentiles}
\title{Calculate Percentiles}
\usage{
dep_percentiles(.data, source_var, new_var)
}
\arguments{
\item{.data}{A tibble containing the data to be used for calculating percentiles.}

\item{source_var}{Required; the quoted or unquoted source variable to be
divided into percentiles.}

\item{new_var}{Required; the quoted or unquoted name of the new variable to
be created containing the quantile values.}
}
\value{
An updated tibble with the percentiles added as a new column or with
    replaced values in the source column.
}
\description{
Calculate percentiles for a given variable in a data frame. This
    is the method used to calculate ranked percentiles for SVI.
}
\examples{
## load sample data
ndi_m <- dep_sample_data(index = "ndi_m")

# calculate percentiles for population 25 years and older
ndi_m <- dep_percentiles(ndi_m, source_var = B06009_001E,
    new_var = pop25_percentile)

# preview the new data
ndi_m[names(ndi_m) \%in\% c("GEOID", "B06009_001E", "pop25_percentile")]

}
