% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dep_build_varlist.R
\name{dep_build_varlist}
\alias{dep_build_varlist}
\title{Create Variable Lists}
\usage{
dep_build_varlist(geography, index, year, survey = "acs5", output = "vector")
}
\arguments{
\item{geography}{A character scalar; one of \code{"state"}, \code{"county"}, or
\code{"tract"}}

\item{index}{A character scalar or vector listing deprivation measures
to return. These include the area deprivation index (\code{"adi"}),
the gini coefficient (\code{"gini"}), two versions of the neighborhood
deprivation index by Messer (\code{"ndi_m"}) and Powell and Wiley
(\code{"ndi_pw"}), and four versions of the social vulnerability
index (\code{"svi10"}, \code{"svi14"}, \code{"svi20"}, and \code{"svi20s"}).}

\item{year}{A numeric scalar between 2010 and 2020}

\item{survey}{A character scalar representing the Census product. It can
be any American Community Survey product (either \code{"acs1"},
\code{"acs3"}, or \code{"acs5"}). Note that \code{"acs3"} was
discontinued after 2013.}

\item{output}{A character scalar; either \code{"vector"} (default) or
\code{tibble}. See Return below.}
}
\value{
A vector of variable names or a \code{tibble} containing both
    variable names, labels, and the measure(s) they are associated with.
}
\description{
This function creates a vector or \code{tibble} containing
    variables included in particular calls.
}
\examples{
# Gini coefficient at the Census tract level
dep_build_varlist(geography = "tract", index = "gini", year = 2019)

}
