% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_PatternRuns}
\alias{plot_PatternRuns}
\title{Plot sum of run-lengths (or average run-lengths) against the number of runs per individual}
\usage{
plot_PatternRuns(runs, mapFile, method = c("sum", "mean"),
  outputName = NULL, savePlots = FALSE, plotTitle = NULL)
}
\arguments{
\item{runs}{a data.frame with runs per individual (group, id, chrom, nSNP, start, end, length)}

\item{mapFile}{map file (.map) file path}

\item{method}{"sum" or "mean" of run lengths per individual sample}

\item{outputName}{title prefix (the base name of graph, if savePlots is TRUE)#'}

\item{savePlots}{should plots be saved out to files or plotted in the graphical terminal (default)?}

\item{plotTitle}{title in plot (default NULL)}
}
\value{
plot of number of runs vs run-length sum/mean per individual sample
}
\description{
Function to plot the sum of run lengths (or the average run length) per individual
against the average number of runs per individual. Points can be differentially
coloured by group/population. This plot can be useful to identify patterns in
the distribution of runs in different groups (e.g. few long runs vs many short runs)
}
\examples{
# getting map and ped paths
genotypeFile <- system.file("extdata", "Kijas2016_Sheep_subset.ped", package = "detectRUNS")
mapFile <- system.file("extdata", "Kijas2016_Sheep_subset.map", package = "detectRUNS")

# calculating runs of Homozygosity
\dontrun{
# skipping runs calculation
runs <- slidingRUNS.run(genotypeFile, mapFile, windowSize = 15, threshold = 0.1,  minSNP = 15,
ROHet = FALSE,  maxOppositeGenotype = 1, maxMiss = 1,  minLengthBps = 100000,  minDensity = 1/10000)
}
# loading pre-calculated data
runsFile <- system.file("extdata", "Kijas2016_Sheep_subset.sliding.csv", package="detectRUNS")
runsDF <- readExternalRuns(inputFile = runsFile, program = 'detectRUNS')

plot_PatternRuns(runs = runsDF, mapFile = mapFile, method = 'sum')
plot_PatternRuns(runs = runsDF, mapFile = mapFile, method = 'mean')

}
