% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_enorm.R
\name{fit_enorm}
\alias{fit_enorm}
\title{Fit the extended nominal response model}
\usage{
fit_enorm(
  dataSrc,
  predicate = NULL,
  fixed_params = NULL,
  method = c("CML", "Bayes"),
  nDraws = 1000,
  merge_within_persons = FALSE
)
}
\arguments{
\item{dataSrc}{a connection to a dexter database, a matrix, or a data.frame with columns: person_id, item_id, item_score}

\item{predicate}{An optional expression to subset data, if NULL all data is used}

\item{fixed_params}{Optionally, an \code{enorm} object from a previous analysis or 
a data.frame with parameters, see details.}

\item{method}{If CML, the estimation method will be Conditional Maximum Likelihood;
otherwise, a Gibbs sampler will be used to produce a sample from the posterior}

\item{nDraws}{Number of Gibbs samples when estimation method is Bayes.}

\item{merge_within_persons}{whether to merge different booklets administered to the same person, enabling linking over persons as well as booklets.}
}
\value{
An object of type \code{enorm}. The following methods are supported:
\itemize{
\item \code{\link[=coef.enorm]{coef}}
\item \code{\link[=plot.enorm]{plot}}
\item \code{\link[stats]{logLik}}
}

In addition, many dexter functions accept an \code{enorm} object as input, e.g.
\itemize{
\item \code{\link{ability}}
\item \code{\link{plausible_values}}
\item \code{\link{plausible_scores}}
\item \code{\link{expected_score}}
}
}
\description{
Fits an Extended NOminal Response Model (ENORM) using conditional maximum likelihood (CML)
or a Gibbs sampler for Bayesian estimation.
}
\details{
The eNRM is a generalization of the PCM and the OPLM. It
reduces to the Rasch model for dichotomous items when all itemscores are 0 or 1, is equal to the PCM for polytomous items if all
itemscores up to the maximum score occur. It is equal to the oplm if all itemscores have an equal common divisor larger than 1.

To support some flexibility in fixing parameters, fixed_params can be a dexter enorm object or a data.frame.
If it is a data.frame, it should contain the columns item_id, item_score and a difficulty parameter beta
}
\references{
Maris, G., Bechger, T.M. and San-Martin, E. (2015) A Gibbs sampler for the (extended) marginal Rasch model. 
Psychometrika. 80(4), 859-879. 

Koops, J. and Bechger, T.M. and Maris, G. (2024); Bayesian inference for multistage and other 
incomplete designs. In Research for Practical Issues and Solutions in Computerized Multistage Testing.
Routledge, London.
}
