% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffdfs.R
\name{diffdfs}
\alias{diffdfs}
\title{Compute the Difference Between Dataframes}
\usage{
diffdfs(new_df, old_df = NA, key_cols = NA, verbose = FALSE)
}
\arguments{
\item{new_df}{A dataframe of new data.}

\item{old_df}{A dataframe of old data. new_df and old_df can (and usually do) have overlapping data.}

\item{key_cols}{optional vector of column names that constitute a unique table key. If NA, colnames(old_df) will be used.}

\item{verbose}{logical, default FALSE. Should the processing be chatty?}
}
\value{
a dataframe.
}
\description{
Returns a dataframe describing the modifications required to transform old_df into new_df.
The dataframes needBugReports: 	https://github.com/tidyverse/dplyr/issues to have identical columns and column types and share unique index columns.
}
\examples{
iris$key <- 1:nrow(iris)

old_df <- iris[1:100,]
old_df[75,1] <- 100
new_df <- iris[50:150,]
diffdfs(new_df, old_df, key_cols = "key")
}
