% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peeling.R
\name{peeling}
\alias{peeling}
\title{Apply the peeling procedure at a given marker}
\usage{
peeling(x, marker.data, cytoband, k)
}
\arguments{
\item{x}{An n by m numeric matrix containing DNA copy number data from n subjects at m markers.}

\item{marker.data}{marker.data A two-column numeric matrix of marker position data for markers in the
autosomes.  Column 1 contains the chromosome number for each marker, and column 2 contains the position
(in base pairs) for each markers.  This is a submatrix of the marker position matrix used by
\code{\link{quickLook}} and \code{\link{detailedLook}}.}

\item{cytoband}{A character vector of length m that contains the chromosome arm (p or q) for each
marker.  This is produced by the \code{\link{makeCytoband}} function.}

\item{k}{A positive integer between 1 and m that represents the most aberrant marker.}
}
\value{
A list containing two components:  (1) the n by m matrix produced by applying the peeling algorithm
to the matrix \code{x} at marker \code{k}, and (2) the peak interval around marker \code{k}, as described
in Bioinformatics (2011) 27(5) 678 - 685.
}
\description{
Apply the peeling procedure at a given marker
}
\details{
The peeling procedure is detailed in Algorithm 2 of Bioinformatics (2011) 27(5) 678 - 685, but here
we provide a brief overview.  By construction, marker \code{k} represents the most aberrant gain (loss).
The peeling procedure rescales all copy number values in \code{x} that contribute to making marker \code{k}
aberrant, so that after applying the peeling procedure marker \code{k} is "null."  By construction, the
rescaling procedure is restricted to entries in \code{x} that correspond to markers in the same chromosome
arm as \code{k}.  This allows users to assess the statistical significance of multiple gains (losses) throughout
the genome.
}
