% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscSurvEvaluation.R
\name{adjDevResid}
\alias{adjDevResid}
\title{Adjusted Deviance Residuals in short format}
\usage{
adjDevResid(dataLong, hazards)
}
\arguments{
\item{dataLong}{Data set in long format ("class data.frame").}

\item{hazards}{Estimated discrete hazards of the data in long format("numeric vector"). Hazard
rates are probabilities and therefore restricted to the interval [0, 1].}
}
\value{
\itemize{ \item{Output} List with objects: \itemize{
\item{AdjDevResid} Adjusted deviance residuals as numeric vector }
\item{Input} A list of given argument input values (saved for reference) }
}
\description{
Calculates the adjusted deviance residuals for arbitrary prediction models.
The adjusted deviance residuals should be approximately normal distributed,
in the case of a well fitting model.
}
\examples{

library(survival)

# Transform data to long format
heart[, "stop"] <- ceiling(heart[, "stop"])
set.seed(0)
Indizes <- sample(unique(heart$id), 25)
randSample <- heart[unlist(sapply(1:length(Indizes), 
function(x) which(heart$id == Indizes[x]))),]
heartLong <- dataLongTimeDep(dataSemiLong = randSample, 
timeColumn = "stop", eventColumn = "event", idColumn = "id", timeAsFactor = FALSE)

# Fit a generalized, additive model and predict discrete hazards on data in long format
library(mgcv)
gamFit <- gam(y ~ timeInt + surgery + transplant + s(age), data = heartLong, family = "binomial")
hazPreds <- predict(gamFit, type = "response")

# Calculate adjusted deviance residuals
devResiduals <- adjDevResid(dataLong = heartLong, hazards = hazPreds)$Output$AdjDevResid
devResiduals

}
\references{
\insertRef{tutzModelDisc}{discSurv} \cr\cr
\insertRef{tutzRegCat}{discSurv}
}
\seealso{
\code{\link{intPredErr}}, \code{\link{predErrCurve}}
}
\author{
Thomas Welchowski \email{welchow@imbie.meb.uni-bonn.de}
}
\keyword{survival}
