% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minNodeSizePruning.R
\name{minNodePruning}
\alias{minNodePruning}
\title{Minimal Node Size Pruning}
\usage{
minNodePruning(
  formula,
  data,
  treetype = "rpart",
  splitruleranger = "hellinger",
  sizes,
  indexList,
  timeColumn,
  eventColumn,
  lambda = 1,
  logOut = FALSE
)
}
\arguments{
\item{formula}{Model formula for tree fitting("class formula")}

\item{data}{Discrete survival data in short format for which a survival tree is
to be fitted ("class data.frame").}

\item{treetype}{Type of tree to be fitted ("character vector"). Possible values are "rpart" or "ranger". The default
is to fit an rpart tree; when "ranger" is chosen, a ranger forest with a single tree is fitted.}

\item{splitruleranger}{String specifying the splitting rule of the ranger tree("character vector"). 
Possible values are either "gini", "extratrees" or "hellinger". Default is "hellinger".}

\item{sizes}{Vector of different node sizes to try ("integer vector"). 
Values should be non-negative.}

\item{indexList}{List of data partitioning indices for cross-validation ("class list").
Each element represents the test indices of one fold ("integer vector").}

\item{timeColumn}{Character giving the column name of the observed times in
the \emph{data} argument ("character vector").}

\item{eventColumn}{Character giving the column name of the event indicator in
the \emph{data} argument ("character vector").}

\item{lambda}{Parameter for laplace-smoothing. A value of 0 corresponds to 
no laplace-smoothing ("numeric vector").}

\item{logOut}{Logical value ("logical vector"). If the argument is set to TRUE, 
then computation progress will be written to console.}
}
\value{
A list containing the two items
\itemize{
  \item Optimal minimal node size - Node size with lowest out-of-sample log-likelihood
  \item tree - a tree object with type corresponding to \emph{treetype} argument with the optimal minimal node size
}
}
\description{
Computes optimal minimal node size of a discrete survival tree from a given vector 
of possible node sizes by cross-validation. Laplace-smoothing can be applied to the 
estimated hazards.
}
\details{
Computes the out-of-sample log likelihood for all data partitionings
for each node size in \emph{sizes} and returns the node size for which the log 
likelihood was minimal. Also returns an rpart tree with the optimal minimal 
node size using the entire data set.
}
\examples{
library(pec)
library(caret)
data(cost)
# Take subsample and convert time to years
cost$time <- ceiling(cost$time / 365)
costSub <- cost[1:50, ]
# Specify column names for data augmentation
timeColumn <- "time"
eventColumn <- "status"
# Create data partition for cross validation
indexList <- createFolds(costSub$status * max(costSub$time) + costSub$time, k = 5)
# specify function arguments and perform node size pruning
formula <- y ~ timeInt + prevStroke + age + sex
sizes <- 1:10
optiTree <- minNodePruning(formula, costSub, treetype = "rpart", sizes = sizes, 
indexList = indexList, timeColumn =  timeColumn, eventColumn = eventColumn, 
lambda = 1, logOut = TRUE)
}
