
<!-- README.md is generated from README.Rmd. Please edit that file -->

# discourseGT

<!-- badges: start -->

[![](https://cranlogs.r-pkg.org/badges/discourseGT)](https://cran.r-project.org/package=discourseGT)
<!-- badges: end -->

R package that converts transcripts to graphs (networks), includes
parameters relevant to educational research

## Purpose

Many disciplines use transcripts to record sequential information.
Transcripts that capture a conversation can become long, making
systematic analyses difficult or time-consuming. This package allows
researchers to visualize transcripts in a succinct format through the
lens of graph theory. [Graph
theory](https://en.wikipedia.org/wiki/Graph_theory) is a discipline of
mathematics involving “nodes” and “edges” that model objects and the
relations between them. The goal is to get more information from
transcripts through this alternative view.

Graphs, nodes, and edges may be characterized in various ways. For
example, the number of edges connected to any particular node is called
the node’s degree. Another example, the number of edges in a graph
divided by the number of possible edges is called the density of the
graph. We consider these characteristics of graphs (calling them
“parameters”) and pick out the relevant ones for educational
researchers.

## Installation

To get started installing the package, run the command
`install.packages('discourseGT')` in R, which will download the most
stable package from CRAN.

## How to Use

The key functions and examples of how to use this package can be found
in [this
document](https://github.com/q1cui/discourseGT/blob/main/vignettes/discourseGT.pdf).

## How to reach out?

### Where do I report bugs?

Please open an issue on GitHub.

### How do I contribute to the package?

If you have an idea (but no code yet), open an issue on GitHub. If you
want to contribute with a specific feature and have the code ready, fork
the repository, add your code, and create a pull request.

### Do you need support?

The easiest way is to open an issue - this way, your question is also
visible to others who may face similar problems.

## License

This package is MIT Licensed  
Written by Albert Chai \<@albertchai\>, Andrew S. Lee \<@alee4738\>,
Joshua P. Le \<@jpl038\>, Jitarth Sheth \<@jshethbright\>, Qi Cui
\<@q1cui\>, and Stanley M. Lo \<@smlo\>
