% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/litsearchr.functions.R, R/suggest_title.R
\name{get_tokens}
\alias{get_tokens}
\title{Remove stopwords from text}
\usage{
get_tokens(text, language = "English")

get_tokens(text, language = "English")
}
\arguments{
\item{text}{An input string}

\item{language}{The language used to look up stop words (default is "English")}
}
\value{
Returns the input text with stopwords removed.

A vector of strings consisting of the non-stop words from the 'text' input
}
\description{
Removes stopwords from text in whichever language is specified.

Removes stop words from a text string (adapted from 'litsearchr' \url{https://github.com/elizagrames/litsearchr/})
and returns the remaining words as a vector of strings
}
\examples{
get_tokens("On the Origin of Species", language="English")
text <- "A methodology for systematic mapping in environmental sciences"
tokens <- get_tokens(text)
tokens;
}
