% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovr_data.R
\docType{data}
\name{social_anxiety}
\alias{social_anxiety}
\title{Social anxiety data}
\format{
A tibble with 134 rows and 4 variables.
}
\source{
\href{https://www.discovr.rocks/csv/social_anxiety.csv}{www.discovr.rocks/csv/social_anxiety.csv}
}
\usage{
social_anxiety
}
\description{
A dataset from Field, A. P. (2026). Discovering statistics using R and RStudio (2nd ed.). London: Sage.
}
\details{
Anxiety disorders take on different shapes and forms, and each disorder is believed to be distinct and have unique causes.
We can summarize the disorders and some popular theories as follows:
\itemize{
\item Social Anxiety: Social anxiety disorder is a marked and persistent fear of 1 or more social or performance situations in which the person is exposed to unfamiliar people or possible scrutiny by others. This anxiety leads to avoidance of these situations. People with social phobia are believed to feel elevated feelings of shame.
\item Obsessive Compulsive Disorder (OCD): OCD is characterized by the everyday intrusion into conscious thinking of intense, repetitive, personally abhorrent, absurd and alien thoughts (Obsessions), leading to the endless repetition of specific acts or to the rehearsal of bizarre and irrational mental and behavioural rituals (compulsions).
}

Social anxiety and obsessive compulsive disorder are seen as distinct disorders having different causes. However, there are some similarities.
They both involve some kind of attentional bias: attention to bodily sensation in social anxiety and attention to things that could have negative consequences in OCD.
They both involve repetitive thinking styles: social phobics ruminate about social encounters after the event (known as post-event processing), and people with OCD
have recurring intrusive thoughts and images. They both involve safety behaviours (i.e. trying to avoid the thing that makes you anxious).

This might lead us to think that, rather than being different disorders, they are manifestations of the same core processes (Field & Cartwright-Hatton, 2008). One way to research
this possibility would be to see whether social anxiety can be predicted from measures of other anxiety disorders. If social anxiety disorder and OCD are distinct we should expect
that measures of OCD will not predict social anxiety. However, if there are core processes underlying all anxiety disorders, then measures of OCD should predict social anxiety.
The data contains three variables:
\itemize{
\item \strong{spai}: The Social Phobia and Anxiety Inventory (SPAI), which measures levels of social anxiety.
\item \strong{iii}: The Interpretation of Intrusions Inventory (III).
\item \strong{obq}: Obsessive Beliefs Questionnaire (OBQ), which measures the degree to which people experience obsessive beliefs like those found in OCD.
\item \strong{tosca}: The Test of Self-Conscious Affect (TOSCA), which measures shame.
}
}
\references{
\itemize{
\item Field, A. P., & Cartwright-Hatton, S. (2008). Shared and unique cognitive factors in social anxiety. \emph{International Journal of Cognitive Therapy}, \emph{1}, 206–222. \doi{10.1521/ijct.2008.1.3.206}
}
}
\keyword{datasets}
