% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distcomp-package.R
\name{createNCPInstance}
\alias{createNCPInstance}
\title{Given the definition identifier of an object, instantiate and store
object in workspace}
\usage{
createNCPInstance(
  name,
  ncpId,
  instanceId,
  pubkey_bits,
  pubkey_n,
  den_bits,
  dataFileName = NULL
)
}
\arguments{
\item{name}{identifying the NC party}

\item{ncpId}{the id indicating the NCP definition}

\item{instanceId}{an indentifier to use for the created instance}

\item{pubkey_bits}{the public key number of bits}

\item{pubkey_n}{the pubkey n}

\item{den_bits}{the denominator number of bits for for rational
approximations}

\item{dataFileName}{a file name to use for saving the
data. Typically \code{NULL}, this is only needed when one is using a
single opencpu server to behave like multiple sites in which
case the data file name serves to distinguish the site-specific
data files.  When it is \code{NULL}, the data file name is taken
from the configuration settings}
}
\value{
TRUE if everything goes well
}
\description{
This function uses an identifier (\code{defnId}) to locate
a stored definition in the workspace to create the appropriate
object instance. The instantiated object is assigned the
instanceId and saved under the dataFileName if the latter is
not \code{NULL}.  This instantiated object may change state between
iterations when a computation executes
}
