% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combdist.R
\name{combdist}
\alias{combdist}
\alias{dcombdist}
\alias{pcombdist}
\alias{qcombdist}
\alias{mcombdist}
\alias{rcombdist}
\title{Combined distributions}
\usage{
dcombdist(
  x,
  dist,
  prior = c(1),
  coeff,
  log = FALSE,
  compress = TRUE,
  lowertrunc = 0,
  uppertrunc = Inf
)

pcombdist(
  q,
  dist,
  prior = 1,
  coeff,
  log.p = FALSE,
  lower.tail = TRUE,
  compress = TRUE,
  lowertrunc = NULL,
  uppertrunc = NULL
)

qcombdist(p, dist, prior, coeff, log.p = FALSE, lower.tail = TRUE)

mcombdist(
  r,
  truncation = NULL,
  dist,
  prior = 1,
  coeff,
  lower.tail = TRUE,
  compress = TRUE,
  uppertrunc = 0,
  lowertrunc = Inf
)

rcombdist(n, dist, prior, coeff, uppertrunc = NULL, lowertrunc = NULL)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{dist}{character vector denoting the distribution(s).}

\item{prior}{Numeric vector of prior coefficients, defaults to single vector with value one.}

\item{coeff}{list of parameters for the distribution(s).}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{compress}{Logical indicating whether return values from individual densities of finite mixtures should be gathered or not, defaults to TRUE.}

\item{lowertrunc, uppertrunc}{lowertrunc- and uppertrunc truncation points, defaults to 0 and Inf respectively}

\item{lower.tail}{logical; if TRUE (default), probabilities (moments) are \eqn{P[X \leq x]} \eqn{(E[x^r|X \leq y])}, otherwise, \eqn{P[X > x]} \eqn{(E[x^r|X > y])}}

\item{p}{vector of probabilities}

\item{r}{rth raw moment of the Pareto distribution}

\item{truncation}{lower truncation parameter}

\item{n}{number of observations}
}
\value{
dcombdist gives the density, pcombdist gives the distribution function, qcombdist gives the quantile function, mcombdist gives the rth moment of the distribution and rcombdist generates random deviates.

 The length of the result is determined by n for rcombdist, and is the maximum of the lengths of the numerical arguments for the other functions.
}
\description{
Density, distribution function, quantile function, raw moments and random generation for combined (empirical, single, composite and finite mixture) truncated or complete distributions.
}
\examples{

\donttest{
# Load necessary tools
data("fit_US_cities")
library(tidyverse)
x <- rcombdist(
  n = 25359, dist = "lnorm",
  prior = subset(fit_US_cities, (dist == "lnorm" & components == 5))$prior[[1]],
  coeff = subset(fit_US_cities, (dist == "lnorm" & components == 5))$coefficients[[1]]
) # Generate data from one of the fitted functions

# Evaluate functioning of dcomdist by calculating log likelihood for all distributions
loglike <- fit_US_cities \%>\%
  group_by(dist, components, np, n) \%>\%
  do(loglike = sum(dcombdist(dist = .[["dist"]], x = sort(x), prior = .[["prior"]][[1]],
  coeff = .[["coefficients"]][[1]], log = TRUE))) \%>\%
  unnest(cols = loglike) \%>\%
  mutate(NLL = -loglike, AIC = 2 * np - 2 * (loglike), BIC = log(n) * np - 2 * (loglike)) \%>\%
  arrange(NLL)

# Evaluate functioning of mcombdist and pcombdist by calculating NMAD
#(equivalent to the Kolmogorov-Smirnov test statistic for the zeroth moment
#of the distribution) for all distributions
nmad <- fit_US_cities \%>\%
  group_by(dist, components, np, n) \%>\%
  do(
    KS = max(abs(pempirical(q = sort(x), data = x) - pcombdist(dist = .[["dist"]],
    q = sort(x), prior = .[["prior"]][[1]], coeff = .[["coefficients"]][[1]]))),
    nmad_0 = nmad_test(r = 0, dist = .[["dist"]], x = sort(x), prior = .[["prior"]][[1]],
    coeff = .[["coefficients"]][[1]], stat = "max"),
    nmad_1 = nmad_test(r = 1, dist = .[["dist"]], x = sort(x), prior = .[["prior"]][[1]],
    coeff = .[["coefficients"]][[1]], stat = "max")
  ) \%>\%
  unnest(cols = c(KS, nmad_0, nmad_1)) \%>\%
  arrange(nmad_0)

# Evaluate functioning of qcombdist pcombdist by calculating NMAD (equivalent to the Kolmogorov-
#Smirnov test statistic for the zeroth moment of the distribution) for all distributions
test <- fit_US_cities \%>\%
  group_by(dist, components, np, n) \%>\%
  do(out = qcombdist(pcombdist(2, dist = .[["dist"]], prior = .[["prior"]][[1]],
  coeff = .[["coefficients"]][[1]], log.p = TRUE),
    dist = .[["dist"]], prior = .[["prior"]][[1]], coeff = .[["coefficients"]][[1]],
    log.p = TRUE
  )) \%>\%
  unnest(cols = c(out))
}

}
