% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dists.R
\name{get_dists}
\alias{get_dists}
\title{Retrieve the distances between i and j from a 'dist' object.}
\usage{
get_dists(x, i, j = NULL, return_indices = FALSE)
}
\arguments{
\item{x}{An object of class 'dist'.}

\item{i}{Either a two column matrix of integer indices or a vector of
indices that are paired with the corresponding elements in j.}

\item{j}{A vector of indices where each element forms a pair with the
corresponding element in argument i.}

\item{return_indices}{Logical indicating whether a three column matrix
containing the provided indices (columns 1 and 2) and their corresponding
distances (column 3) should be returned. The default behavior is to return
a vector of distances.}
}
\value{
A vector giving the distances between the provided indices.
}
\description{
Retrieve the distances between i and j from a 'dist' object.
}
\examples{
test <- matrix(rnorm(20), ncol = 2)
test_dists <- dist(test)
indices <- matrix(sample(1:8),ncol=2)
get_dists(test_dists, indices)
}
