% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampstat.R
\name{sumstat}
\alias{sumstat}
\title{Occurrence database summary}
\usage{
sumstat(
  x,
  tax = "genus",
  bin = "stg",
  coll = NULL,
  ref = NULL,
  duplicates = NULL
)
}
\arguments{
\item{x}{\code{(data.frame)}: The occurrence dataset.}

\item{tax}{\code{(character)}: The column name of taxon names.}

\item{bin}{\code{(character)}: The column name of bin names.}

\item{coll}{\code{(character)}: The column name of collection numbers. (optional)}

\item{ref}{\code{(character)}: The column name of reference numbers. (optional)}

\item{duplicates}{\code{(logical)}: The function will check whether there are duplicate occurrences (multiple species/genera). When set to \code{NULL}, nothing will happen, but the function will notify you if duplicates are present. If set to \code{TRUE}, the function will not do anything with these, if set to \code{FALSE}, the duplicates will be omitted.}
}
\value{
A named numeric vector.
}
\description{
The function calculates global statistics of the entire database
}
\details{
The function returns the following values.

 \code{bins}: The total number of bins sampled. 

\code{occs}: The total number of sampled occurrences.

\code{colls}: The total number of sampled collections.

\code{refs}:  The total number of sampled references.

\code{taxa}:  The total number of sampled taxa.

 \code{gappiness}: The proportion of sampling gaps in the ranges of the taxa (without the range-endpoints).
}
\examples{
data(corals)
  sumstat(corals, tax="genus", bin="stg", coll="collection_no", ref="reference_no")
}
