% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile_similarity.R
\name{profile_similarity}
\alias{profile_similarity}
\alias{profile_similarity.numeric}
\alias{profile_similarity.species_distribution}
\title{Similarity-Based Diversity Profile of a Community}
\usage{
profile_similarity(
  x,
  similarities,
  orders = seq(from = 0, to = 2, by = 0.1),
  ...
)

\method{profile_similarity}{numeric}(
  x,
  similarities = diag(length(x)),
  orders = seq(from = 0, to = 2, by = 0.1),
  estimator = c("UnveilJ", "Max", "ChaoShen", "MarconZhang", "UnveilC", "UnveiliC",
    "naive"),
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  richness_estimator = c("jackknife", "iChao1", "Chao1", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  sample_coverage = NULL,
  as_numeric = FALSE,
  n_simulations = 0,
  alpha = 0.05,
  bootstrap = c("Chao2015", "Marcon2012", "Chao2013"),
  show_progress = TRUE,
  ...,
  check_arguments = TRUE
)

\method{profile_similarity}{species_distribution}(
  x,
  similarities = diag(sum(!colnames(x) \%in\% non_species_columns)),
  orders = seq(from = 0, to = 2, by = 0.1),
  estimator = c("UnveilJ", "Max", "ChaoShen", "MarconZhang", "UnveilC", "UnveiliC",
    "naive"),
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  gamma = FALSE,
  n_simulations = 0,
  alpha = 0.05,
  bootstrap = c("Chao2015", "Marcon2012", "Chao2013"),
  show_progress = TRUE,
  ...,
  check_arguments = TRUE
)
}
\arguments{
\item{x}{An object, that may be a numeric vector containing abundances or probabilities,
or an object of class \link{abundances} or \link{probabilities}.}

\item{similarities}{a similarity matrix, that can be obtained by \link{fun_similarity}.
Its default value is the identity matrix.}

\item{orders}{The orders of diversity used to build the profile.}

\item{...}{Unused.}

\item{estimator}{An estimator of entropy.}

\item{probability_estimator}{a string containing one of the possible estimators
of the probability distribution (see \link{probabilities}).
Used only for extrapolation.}

\item{unveiling}{a string containing one of the possible unveiling methods
to estimate the probabilities of the unobserved species (see \link{probabilities}).
Used only for extrapolation.}

\item{richness_estimator}{an estimator of richness to evaluate the total number of species,
see \link{div_richness}. used for interpolation and extrapolation.}

\item{jack_alpha}{the risk level, 5\% by default, used to optimize the jackknife order.}

\item{jack_max}{the highest jackknife order allowed. Default is 10.}

\item{coverage_estimator}{an estimator of sample coverage used by \link{coverage}.}

\item{sample_coverage}{the sample coverage of \code{x} calculated elsewhere.
Used to calculate the gamma diversity of meta-communities, see details.}

\item{as_numeric}{if \code{TRUE}, a number or a numeric vector is returned rather than a tibble.}

\item{n_simulations}{The number of simulations used to estimate the confidence envelope of the profile.}

\item{alpha}{The risk level, 5\% by default, of the confidence envelope of the profile.}

\item{bootstrap}{the method used to obtain the probabilities to generate
bootstrapped communities from observed abundances.
If "Marcon2012", the probabilities are simply the abundances divided by the total
number of individuals \insertCite{Marcon2012a}{divent}.
If "Chao2013" or "Chao2015" (by default), a more sophisticated approach is used
(see \link{as_probabilities}) following \insertCite{Chao2013;textual}{divent} or
\insertCite{Chao2015;textual}{divent}.}

\item{show_progress}{if TRUE, a progress bar is shown during long computations.}

\item{check_arguments}{if \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}

\item{gamma}{if \code{TRUE}, \eqn{\gamma} diversity, i.e. diversity of the metacommunity, is computed.}
}
\value{
A tibble with the site names, the estimators used and the estimated diversity at each order.
This is an object of class "profile" that can be plotted.
}
\description{
Calculate the diversity profile of a community, i.e. its similarity-based diversity
against its order.
}
\details{
A bootstrap confidence interval can be produced by simulating communities
(their number is \code{n_simulations}) with \link{rcommunity} and calculating their profiles.
Simulating communities implies a downward bias in the estimation:
rare species of the actual community may have abundance zero in simulated communities.
Simulated diversity values are recentered so that their mean is that of the actual community.
}
\examples{
# Similarity matrix
Z <- fun_similarity(paracou_6_fundist)
# Profile
profile_similarity(paracou_6_abd, similarities = Z, q = 2)

}
\references{
\insertAllCited{}
}
