#' Build the observation covariance matrix for Predictive Dynamic Linear Models (pdlm)
#'
#'
#' @param x model parameters
#' @param k the dimension of observation equation
#'
#' @return A matrix with proper dimension.
#'
#' @noRd
#'
getV <- function(x, k){

  if(length(x)==2){
    V <- c(x[1], rep(x[2], k-1))#c(x[1], rep(x[2], k-1))
  }else{
    V <- x
  }
  V <- diag(V, nrow=k)
  return(V)
}
