% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchDocket.r
\name{checkBatchDictionary}
\alias{checkBatchDictionary}
\title{Check that the batch dictionary is valid}
\usage{
checkBatchDictionary(batchDictionary)
}
\arguments{
\item{batchDictionary}{A data frame where each row represents a flag to be replaced in the template document
and each column represents a final document to be generated}
}
\value{
Logical. Returns 'TRUE' if the batch dictionary meets requirements for processing. Returns 'FALSE' otherwise
}
\description{
Validates that the input batch dictionary meets the following requirements:
#' #' \itemize{
\item \strong{1.} It is a data frame
\item \strong{2.} Column 1 is named "flag"
\item \strong{3.} Column 1 contains flags with starting and ending wings: « »
\item \strong{4.} Row 1 contains the file names and paths of the populated output documents
}
}
\examples{
# Path to the sample template file included in the package
template_path <- system.file("batch_document", "batchTemplate.docx", package="docket")
temp_dir <- normalizePath(tempdir(), winslash = "/")
output_paths <- as.list(paste0(temp_dir, paste0("/batch document", 1:5, ".docx")))

# Create a dictionary by using the getDictionary function on the sample template file
result <- getBatchDictionary(template_path, output_paths)
result[2,2:ncol(result)] <- Sys.getenv("USERNAME") #Author name
result[3,2:ncol(result)] <- as.character(Sys.Date())
result[4,2:ncol(result)] <- 123
result[5,2:ncol(result)] <- 456
result[6,2:ncol(result)] <- 789
result[7,2:ncol(result)] <- sum(as.numeric(result[4:6,2]))

# Verify that the result dictionary is valid
if (checkBatchDictionary(result) == TRUE) {
  print("Valid Batch Dictionary")
}
}
