% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcrd2fact.R
\name{fcrd2fact}
\alias{fcrd2fact}
\title{Analysis of Factorial Completely Randomized Design for 2 factors}
\usage{
fcrd2fact(data, fact.A, fact.B, Multiple.comparison.test)
}
\arguments{
\item{data}{dependent variables}

\item{fact.A}{vector containing levels of first factor}

\item{fact.B}{vector containing levels of second factor}

\item{Multiple.comparison.test}{0 for no test, 1 for LSD test, 2 for Duncan test and 3 for HSD test}
}
\value{
ANOVA, interpretation of ANOVA, R-square, normality test result, SEm, SEd and multiple comparison test result for both the factors as well as interaction.
}
\description{
The function gives ANOVA, R-square of the model, Normality testing of residuals, SEm (standard error of mean), SEd (standard error of difference), interpretation of ANOVA results and multiple comparison test for means
}
\examples{
data(factorialdata)
#Analysis of Factorial Completely Randomized design along with Dunccan test for Yield only
fcrd2fact(factorialdata[5],factorialdata$Nitrogen,factorialdata$Phosphorus,2)
#Analysis of Factorial Completely Randomized design along with Dunccan test for Yield & Plant Height
fcrd2fact(factorialdata[5:6],factorialdata$Nitrogen,factorialdata$Phosphorus,2)
}
