% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcbd.R
\name{rcbd}
\alias{rcbd}
\title{Analysis of Randomized Complete Block Design}
\usage{
rcbd(data, treatmentvector, replicationvector, MultipleComparisonTest)
}
\arguments{
\item{data}{dependent variables}

\item{treatmentvector}{vector containing treatments}

\item{replicationvector}{vector containing replications}

\item{MultipleComparisonTest}{0 for no test, 1 for LSD test, 2 for Duncan test and 3 for HSD test}
}
\value{
ANOVA, interpretation of ANOVA, R-square, normality test result, SEm, SEd and multiple comparison test result
}
\description{
The function gives ANOVA, R-square of the model, normality testing of residuals, SEm (standard error of mean), SEd (standard error of difference), interpretation of ANOVA results and multiple comparison test for means.
}
\examples{
data<-data.frame(GFY=c(16,13,14,16,16,17,16,17,16,16,17,16,15,15,15,13,15,14,
16,14,15,14,15,17,18,15,15,15,14,14,14,14,15,15,13,15,14,14,13,13,13,12,15,12,15),
DMY=c(5,5,6,5,6,7,6,8,6,9,8,7,5,5,5,4,6,5,8,5,5,5,4,6,6,5,5,6,6,6,5,5,5,5,5,6,5,5,5,4,5,4,5,5,5),
Rep=rep(c("R1","R2","R3"),each=15),
Trt=rep(c("T1","T2","T3","T4","T5","T6","T7","T8","T9","T10","T11","T12","T13","T14","T15"),3))
#' #RCBD analysis with duncan test for GFY only
rcbd(data[1],data$Trt,data$Rep,2)
#RCBD analysis with duncan test for both GFY and DMY
rcbd(data[1:2],data$Trt,data$Rep,2)
}
