% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doubt.R
\name{?}
\alias{?}
\title{Modified question mark operator}
\usage{
`?`(e1, e2)
}
\arguments{
\item{e1}{lhs}

\item{e2}{rhs}
}
\description{
\verb{?} was modified to allow definition of new operators (unary, binary or n-ary).
We refer to those as "dubious" operators, both as a reference to the
package name and to emphasize the fact that they're not parsed as proper
operators.
.
Standard usage as documented in \code{?utils::Question} still works.
}
\section{dubious operators}{


Every accessible function, custom defined or base/packaged, can be called as
an infix operator, for example \code{1:5 \%\%intersect? 3:7} is equivalent to
\code{intersect(1:5, 3:7)}. In that case, \verb{\%\%intersect?} will have the precedence
of \code{\%\%}, which is the most intuitive,
but any precedence including and below unary \code{+} can be used, for instance
\verb{*intersect?} will have the precedence of \code{*}.

Unary operators can be used to, for instance \code{~head? x} is the same as
\code{head(x)}. This form can also be used with several arguments, but in this
case we need to write \verb{~head? \{x ; n)} for instance, which is convenient to go
to the next line without the need of a comma.
}

\section{dubious pipes}{


We can pipe with a chosen precedence by using a dubious pipe, for instance
\code{x + y ~saveRDS? file} will save \code{x + y}, not just \code{x}

We can pipe with a chosen precedence by using a dubious pipe, for instance
\code{x + y ~saveRDS? file} will save \code{x + y}, not just \code{x}
}

\section{dubious syntaxes}{


defining \code{"?add: ({x})({y})" <- "{x} + {y}"} will allow us to call
\code{?add: (a)(b)} to add \code{a} and \code{b}.
}

\examples{
cars +head? 2
+head? cars
+head? {
  cars
  2}
}
