% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{testSP}
\alias{testSP}
\title{Performs SP (switch proportion) test on switch data}
\usage{
testSP(
  switches,
  permuteAll = FALSE,
  from = NULL,
  to = NULL,
  dropzeroes = TRUE,
  bylineage = FALSE,
  pseudocount = 0,
  alternative = c("greater", "two.sided", "less"),
  tip_switch = 20,
  exclude = FALSE
)
}
\arguments{
\item{switches}{Data frame from findSwitches}

\item{permuteAll}{Permute among trees?}

\item{from}{Include only switches from this state?}

\item{to}{Include only switches to this state?}

\item{dropzeroes}{Drop switches with zero counts?}

\item{bylineage}{Perform test for each lineage individually?}

\item{pseudocount}{Pseudocount for P value calculations}

\item{alternative}{Perform one-sided (\code{greater} or \code{less})
or \code{two.sided} test}

\item{tip_switch}{maximum tip/switch ratio}

\item{exclude}{exclude clones with tip/switch ratio > \code{tip_switch}?}
}
\value{
A list containing a \code{tibble} with mean SP statistics, and another 
with SP statistics per repetition.
}
\description{
\code{testSP} performs an SP test
}
\details{
Output data table columns:
RECON = SP for observed data
PERMUTE = SP for permuted data
DELTA = RECON - PERMUTE
PLT = p value for DELTA < 0
PGT = p value for DELTA < 0
\itemize{
  \item  \code{FROM}: State going from.
  \item  \code{TO}: State going to.
  \item  \code{RECON}: SP for observed data.
  \item  \code{PERMUTE}: SP for permuted data.
  \item  \code{DELTA}:  RECON - PERMUTE.
  \item  \code{PLT}: p value that DELTA < 0
  \item  \code{PGT}: p value that DELTA > 0
  \item  \code{STAT}: Statistic used (SP).
  \item  \code{REP}: Bootstrap repetition.
  \item  \code{REPS}: Total number of bootstrap repetition.
}
}
\examples{
\dontrun{
igphyml <- "~/apps/igphyml/src/igphyml"
data(ExampleAirr)
ExampleAirr$sample_id = sample(ExampleAirr$sample_id)
clones = formatClones(ExampleAirr, trait="sample_id")
btrees = findSwitches(clones[1:2], bootstraps=10, nproc=1,
   igphyml=igphyml, trait="sample_id")
testSP(btrees$switches)
}
}
\seealso{
Uses output from \link{findSwitches}. Related to \link{testPS}
and \link{testSC}.
}
