% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{get.meta}
\alias{get.meta}
\title{Internal function that gathers meta data on the input to function dpa}
\usage{
get.meta(out.formula, mediator.formulas, data)
}
\arguments{
\item{out.formula}{Survival formula for Aalen's additive hazards model.}

\item{mediator.formulas}{list of mediator regression formulas.}

\item{data}{Data set in counting process format. In particular the data should contain a "start", "stop" and "event" column along with any mediators and baseline covariates.}
}
\value{
list of meta data associated with out.formula and mediator.formulas. Consists of the following fields:
\describe{
\item{outcome}{list containing variable names for startt, stopt, event, and right hand side of out.formula}
\item{mediator}{list containing response variable name and right hand side of mediator.formulas}
\item{variables}{list containing the class of variables in out.formula and mediator.formulas}
}
}
\description{
Do not call this function on its own
}
\examples{
library(dpasurv)

data(simdata)

meta <- get.meta(Surv(start, stop, event) ~ x + M, list(M ~ x), simdata)
}
\keyword{internal}
