% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dppmix_mvnorm.R
\name{dppmix_mvnorm}
\alias{dppmix_mvnorm}
\title{Fit a determinantal point process multivariate normal mixture model.}
\usage{
dppmix_mvnorm(
  X,
  hparams = NULL,
  store = NULL,
  control = NULL,
  fixed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{X}{\code{N x J} data matrix of \code{N} observations and
\code{J} features}

\item{hparams}{a list of hyperparameter values:
\code{delta, a0, b0, theta, sigma_prop_mu}}

\item{store}{a vector of character strings specifying additional vars of
interest; a value of \code{NA} indicates that
samples of all parameters in the model will be stored}

\item{control}{a list of control parameters:
\code{niter, burnin, thin}}

\item{fixed}{a list of fixed parameter values}

\item{verbose}{whether to emit verbose message}
}
\value{
a \code{dppmix_mcmc} object containing posterior samples of
        the parameters
}
\description{
Discover clusters in multidimensional data using a multivariate normal 
mixture model with a determinantal point process prior.
}
\details{
A determinantal point process (DPP) prior is a repulsive prior.
Compare to mixture models using independent priors, a DPP mixutre model
will often discover a parsimonious set of mixture components (clusters).

Model fitting is done by sampling parameters from the posterior
distribution using a reversible jump Markov chain Monte Carlo sampling
approach.

Given \eqn{X = [x_i]}, where each \eqn{x_i} is a D-dimensional real vector,
we seek the posterior distribution the latent variable \eqn{z = [z_i]}, where
each \eqn{z_i} is an integer representing cluster membership.

\deqn{ x_i \mid z_i  \sim  Normal(\mu_k, \Sigma_k) }
\deqn{ z_i           \sim  Categorical(w) }
\deqn{ w             \sim  Dirichlet([\delta ... \delta]) }
\deqn{ \mu_k         \sim  DPP(C) }

where \eqn{C} is the covariance function that evaluates the distances among the
data points:

\deqn{ C(x_1, x_2) = exp( - \sum_d \frac{ (x_1 - x_2)^2 }{ \theta^2 } ) }

We also define \eqn{\Sigma_k = E_k \Lambda_k E_k^\top}, where \eqn{E_k} is an
orthonormal matrix whose column represents eigenvectors.
We further assume that \eqn{E_k = E} is fixed across all cluster components 
so that \eqn{E} can be estimated as the eigenvectors of the covariance matrix of
the data matrix \eqn{X}. Finally, we put a prior on the entries of the
\eqn{\Lambda_k} diagonal matrix:

\deqn{ \lambda_{kd}^{-1}  \sim  Gamma( a_0, b_0 ) }

Hence, the hyperameters of the model include:
\code{delta, a0, b0, theta}, as well as sampling hyperparameter
\code{sigma_pro_mu}, which controls the spread of the Gaussian
proposal distribution for the random-walk Metropolis-Hastings update of
the \eqn{\mu} parameter.

The parameters (and their dimensions) in the model include:
\code{K}, \code{z (N x 1)}, \code{w (K x 1)}, \code{lambda (K x J)},
\code{mu (K x J)}, \code{Sigma (J x J x K)}.
If any parameter is fixed, then \code{K} must be fixed as well.
}
\examples{
set.seed(1)
ns <- c(3, 3)
means <- list(c(-6, -3), c(0, 4))
d <- rmvnorm_clusters(ns, means)

mcmc <- dppmix_mvnorm(d$X, verbose=FALSE)
res <- estimate(mcmc)
table(d$cl, res$z)

}
\references{
Yanxun Xu, Peter Mueller, Donatello Telesca.
            Bayesian Inference for Latent Biologic Structure with
            Determinantal Point Processes.
            Biometrics. 2016;72(3):955-64.
}
