% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dr4pl-param.R
\name{dr4pl-param}
\alias{dr4pl-param}
\alias{dr4pl_theta}
\alias{dr4pl_param}
\alias{ParmToLog}
\alias{ParmToLog.dr4pl_theta}
\alias{ParmToLog.dr4pl_log10}
\alias{LogToParm}
\alias{LogToParm.dr4pl_theta}
\alias{LogToParm.dr4pl_log10}
\title{Constructor for dr4pl theta parameter}
\usage{
dr4pl_theta(
  theta_1 = NA,
  theta_2 = NA,
  theta_3 = NA,
  theta_4 = NA,
  isLog10 = FALSE
)

ParmToLog(x)

\method{ParmToLog}{dr4pl_theta}(x)

\method{ParmToLog}{dr4pl_log10}(x)

LogToParm(x)

\method{LogToParm}{dr4pl_theta}(x)

\method{LogToParm}{dr4pl_log10}(x)
}
\arguments{
\item{theta_1}{Numeric. The upper asymptote of the 4pl model.}

\item{theta_2}{Numeric. The value where Response is half way
between the upper and lower asymptotes. This parameter
is other wise known as IC50/EC50.}

\item{theta_3}{Numeric. The slope of the 4pl model. When `theta_3>0`
the curve increases, and when `theta_3<0`, the curve
decreases.}

\item{theta_4}{Numeric. The lower asymptote of the 4pl model.}

\item{isLog10}{Logical value indicating if the second parameter
is on the log10 scale. The default, FALSE, informs dr4pl that
the value passed to the `theta_2` argument is on the linear
scale. TRUE will indicate that `theta_2` has already been
transformed with \link[base]{log10}. This ensures that the
parameters are handled properly later on.}

\item{x}{a dr4pl_param object}
}
\value{
an object of class `"dr4pl_param"`
}
\description{
As of version 2.0.0, dr4pl will
require the theta parameter to be made by this
function. This is to ensure the user is explicit
about what their parameter is, and what is being
optimized.
}
\details{
The function `dr4pl_theta` is a constructor function for the
end user. While the default values for `theta_1`, `theta_2`,
`theta_3`, `theta_4` are `NA`, certain functions of
`dr4pl` will not allow `NA` values. When `dr4pl_theta` is
used with the `init.parm` argument of [dr4pl], then
values with `NA` will be estimated, and those specified,
will be set as the initial parameter prior to optimization.
If `dr4pl_theta` is the object of S3 dispatch, then
no NA values are allowed. However if the object if
dispatch is a `dr4pl` object, and `dr4pl_theta` is passed
into the function as an additional object such as in [X], [Y],
then parameter non-NA values will be replaced in the appropriate
dr4pl parameter estimates for the purpose of said function.
}
