% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{drawExport}
\alias{drawExport}
\title{Export Current Drawing Page to a File}
\usage{
drawExport(f, width = .pkgenv$pageWidth, height = .pkgenv$pageHeight,
  ppi = .pkgenv$exportPPI, format = tools::file_ext(f),
  textSize = .pkgenv$textSize, units = .pkgenv$exportUnits, ...)
}
\arguments{
\item{f}{Character value of the file path to save to. Must include file name and extension.}

\item{width}{Numeric value of the image width.}

\item{height}{Numeric value of the image height.}

\item{ppi}{Numeric value of the image resolution quality in Pixels Per Inch (PPI).}

\item{format}{Character value of the extension for file without a period ".".}

\item{textSize}{Size of text (pt) in image.}

\item{units}{Character value for the unit to use when specifying measurements. Can be one of the following:
\itemize{
  \item "px", "pixels", "pixel", "pix"
  \item "in", "inches", "inch"
  \item "cm", "centimeters", "centimeter", "centimetre", "centimetres"
  \item "mm", "millimeters", "millimeter", "millimetre", "millimetres"
}}

\item{...}{Additional arguments passed to \link[grDevices]{dev.copy}.}
}
\value{
The name and number of the device, according to \link[grDevices]{dev.copy}, which has been copied to.
}
\description{
Export Current Drawing Page to a File
}
\examples{
library(draw)

# Set drawing settings
drawSettings(pageWidth = 5, pageHeight = 5, units = "inches")

# Create a new drawing page
drawPage()

# Draw a square
drawBox(x = 1, y = 4, width = 2, height = 2)

# Export the drawing page to a PDF
drawExport("export.pdf")

# Export the drawing page to a PNG
drawExport("export.png", ppi=300)

}
\seealso{
\link{drawSettings}
}
