% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglogistic6.R
\name{loglogistic6_gradient_2}
\alias{loglogistic6_gradient_2}
\alias{loglogistic6_hessian_2}
\alias{loglogistic6_gradient_hessian_2}
\title{6-parameter log-logistic function gradient and Hessian}
\usage{
loglogistic6_gradient_2(x, theta)

loglogistic6_hessian_2(x, theta)

loglogistic6_gradient_hessian_2(x, theta)
}
\arguments{
\item{x}{numeric vector at which the function is to be evaluated.}

\item{theta}{numeric vector with the six parameters in the form
\code{c(alpha, delta, eta, phi, nu, xi)}.}
}
\value{
Gradient or Hessian of the alternative parameterization evaluated at
the specified point.
}
\description{
Evaluate at a particular set of parameters the gradient and Hessian of the
6-parameter log-logistic function.
}
\details{
The 6-parameter log-logistic function \verb{f(x; theta)} is defined here as

\verb{g(x; theta) = (x^eta / (xi * x^eta + nu * phi^eta))^(1 / nu)}
\verb{f(x; theta) = alpha + delta g(x; theta)}

where \code{x >= 0}, \code{theta = c(alpha, delta, eta, phi, nu, xi)}, \code{eta > 0},
\code{phi > 0}, \code{nu > 0}, and \code{xi > 0}.

This set of functions use a different parameterization from
\code{link[drda]{loglogistic6_gradient}}. To avoid the non-negative
constraints of parameters, the gradient and Hessian computed here are for
the function with \code{eta2 = log(eta)}, \code{phi2 = log(phi)}, \code{nu2 = log(nu)}, and
\code{xi2 = log(xi)}.

Note that argument \code{theta} is on the original scale and not on the log scale.

\strong{Note}: The 6-parameter log-logistic function is over-parameterized and
non-identifiable from data. It is available only for theoretical research.
}
