% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twomode_EffectiveSize.R
\name{computeBCES}
\alias{computeBCES}
\title{Compute Burchard and Cornwell's (2018) Two-Mode Effective Size}
\usage{
computeBCES(
  net,
  inParallel = FALSE,
  nCores = NULL,
  isolates = NA,
  weighted = FALSE
)
}
\arguments{
\item{net}{A two-mode adjacency matrix or affiliation matrix}

\item{inParallel}{TRUE/FALSE. TRUE indicates that parallel processing will be used to compute the statistic with the \emph{foreach} package. FALSE indicates that parallel processing will not be used. Set to FALSE by default.}

\item{nCores}{If inParallel = TRUE, the number of computing cores for parallel processing. If this value is not specified, then the function internally provides it by dividing the number of available cores in half.}

\item{isolates}{What value should isolates be given? Preset to be NA.}

\item{weighted}{TRUE/FALSE. TRUE indicates the statistic will be based on the weighted formula (see the details section). FALSE indicates the statistic will be based on the original non-weighted formula. Set to FALSE by default.}
}
\value{
The vector of two-mode effective size values for level 1 actors in a two-mode network.
}
\description{
This function calculates the values for two-mode effective size for
weighted and unweighted two-mode networks based on Burchard and Cornwell (2018).
}
\details{
The formula for two-mode effective size is:
\deqn{ES_{i} = |\sigma(i)| - \sum_{j \in \sigma(i)} r_{ij}}
where:
\itemize{
\item \eqn{ES_{i}} is the effective size of ego \emph{i}.
\item \eqn{|\sigma(i)|} is the number of same-class contacts of ego \emph{i}.
\item \eqn{\sum_{j \in \sigma(i)} r_{ij}} is the summation of the redundancy
for each alter \emph{j} in the two-mode ego network of \emph{i}.
}
This function allows the user to compute the scores in parallel through the \emph{foreach} and \emph{doParallel} R packages.
If the matrix is weighted, the user should specify \emph{weighted = TRUE}. If the matrix is weighted, following
Burchard and Cornwell (2018), the formula for two-mode weighted redundancy is:
\deqn{r_{ij} = \frac{|\sigma(j) \cap \sigma(i)|}{|\sigma(i)| \times w_t}}
where \eqn{w_t} is the average of the tie weights that \emph{i} and \emph{j} send
to their shared opposite class contacts.
}
\examples{

# For this example, we recreate Figure 2 in Burchard and Cornwell (2018: 13)
BCNet <- matrix(
 c(1,1,0,0,
   1,0,1,0,
   1,0,0,1,
   0,1,1,1),
 nrow = 4, ncol = 4, byrow = TRUE)
colnames(BCNet) <- c("1", "2", "3", "4")
rownames(BCNet) <- c("i", "j", "k", "m")
#library(sna) #To plot the two mode network, we use the sna R package
#gplot(BCNet, usearrows = FALSE,
#      gmode = "twomode", displaylabels = TRUE)
computeBCES(BCNet)

#In this example, we recreate Figure 9 in Burchard and Cornwell (2018:18)
#for weighted two mode networks.
BCweighted <- matrix(c(1,2,1, 1,0,0,
                      0,2,1,0,0,1),
                      nrow = 4, ncol = 3,
                      byrow = TRUE)
rownames(BCweighted) <- c("i", "j", "k", "l")
computeBCES(BCweighted, weighted = TRUE)

}
\references{
Burchard, Jake and Benjamin Cornwell. 2018. "Structural Holes and Bridging
in Two-Mode Networks." \emph{Social Networks} 55:11-20.
}
\author{
Kevin A. Carson \href{mailto:kacarson@arizona.edu}{kacarson@arizona.edu}, Diego F. Leal \href{mailto:dflc@arizona.edu}{dflc@arizona.edu}
}
