% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariate_drift.R
\name{calculate_covariate_drift}
\alias{calculate_covariate_drift}
\title{Calculate Covariate Drift for two data frames}
\usage{
calculate_covariate_drift(data_old, data_new, bins = 20)
}
\arguments{
\item{data_old}{data frame with `old` data}

\item{data_new}{data frame with `new` data}

\item{bins}{continuous variables are discretized to `bins` intervals of equal sizes}
}
\value{
an object of a class `covariate_drift` (data.frame) with Non-Intersection Distances
}
\description{
Here covariate drift is defined as Non-Intersection Distance between two distributions.
More formally, $$d(P,Q) = 1 - sum_i min(P_i, Q_i)$$.
The larger the distance the more different are two distributions.
}
\examples{
library("DALEX")
# here we do not have any drift
d <- calculate_covariate_drift(apartments, apartments_test)
d
# here we do have drift
d <- calculate_covariate_drift(dragons, dragons_test)
d

}
