% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word.R
\name{word_probabilities}
\alias{word_probabilities}
\title{Probabilities of a word at several positions of a DMM}
\usage{
word_probabilities(word, pos, x, output_file = NULL, plot = FALSE)
}
\arguments{
\item{word}{A subsequence (string of characters)}

\item{pos}{A vector of integer positions}

\item{x}{An object of class \code{dmm}}

\item{output_file}{(Optional) A file containing the vector of probabilities (e.g,"C:/.../PROB.txt")}

\item{plot}{\code{FALSE} (default); \code{TRUE} (display figure plot of word's probabilities by position)}
}
\value{
A numeric vector, probabilities of \code{word}
}
\description{
Probabilities of a word at several positions of a DMM
}
\examples{
data(lambda, package = "drimmR")
dmm <- fitdmm(lambda, 1, 1, c('a','c','g','t'),
init.estim = "freq", fit.method="sum")
word_probabilities("aggctga",c(100,300),dmm, plot=TRUE)
}
\references{
\insertRef{BaVe2018}{drimmR}
\insertRef{Ver08}{drimmR}
}
\seealso{
\link[drimmR]{fitdmm}, \link[drimmR]{getTransitionMatrix}, \link[drimmR]{word_probability}, \link[drimmR]{words_probabilities}
}
\author{
Victor Mataigne, Alexandre Seiller
}
