% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugdevelopR-package.R
\docType{package}
\name{drugdevelopR-package}
\alias{drugdevelopR-package}
\title{drugdevelopR: Utility-Based Optimal Phase II/III Drug Development Planning}
\description{
Plan optimal sample size allocation and go/no-go decision rules for phase II/III drug development programs with time-to-event, binary or normally distributed endpoints when assuming fixed treatment effects or a prior distribution for the treatment effect, using methods from Kirchner et al. (2016) \doi{10.1002/sim.6624} and Preussler (2020). Optimal is in the sense of maximal expected utility, where the utility is a function taking into account the expected cost and benefit of the program. It is possible to extend to more complex settings with bias correction (Preussler S et al. (2020) \doi{10.1186/s12874-020-01093-w}), multiple phase III trials (Preussler et al. (2019) \doi{10.1002/bimj.201700241}), multi-arm trials (Preussler et al. (2019) \doi{10.1080/19466315.2019.1702092}), and multiple endpoints (Kieser et al. (2018) \doi{10.1002/pst.1861}).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/Sterniii3/drugdevelopR}
  \item \url{https://sterniii3.github.io/drugdevelopR/}
  \item Report bugs at \url{https://github.com/Sterniii3/drugdevelopR/issues}
}

}
\author{
\strong{Maintainer}: Lukas D. Sauer \email{sauer@imbi.uni-heidelberg.de} (\href{https://orcid.org/0000-0002-1340-9994}{ORCID})

Authors:
\itemize{
  \item Stella Erdmann \email{erdmann@imbi.uni-heidelberg.de}
  \item Johannes Cepicka
  \item Marietta Kirchner
  \item Meinhard Kieser
}

}
\keyword{internal}
