% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fun.R
\name{plot_circ_points}
\alias{plot_circ_points}
\title{Plot objects (as points) arranged on a circle}
\usage{
plot_circ_points(
  n = 4,
  x_org = 0,
  y_org = 0,
  radius = 1,
  show_axes = FALSE,
  show_label = FALSE,
  ...
)
}
\arguments{
\item{n}{The number of points (or shapes defined by \code{pch}) to plot.}

\item{x_org}{The x-value of circle origin.}

\item{y_org}{The y-value of circle origin.}

\item{radius}{The circle radius.}

\item{show_axes}{Show axes? Default: \code{show_axes = FALSE}.}

\item{show_label}{Show a point label? Default: \code{show_label = FALSE}.}

\item{...}{Additional aesthetics (passed to \code{\link{points}} of \strong{graphics}).}
}
\description{
\code{plot_circ_points} arranges a number of \code{n} 
on a circle (defined by its origin coordinates and radius).
}
\details{
The \code{...} is passed to \code{\link{points}} of 
the \strong{graphics} package.
}
\examples{
plot_circ_points(8)  # default

# with aesthetics of points():
plot_circ_points(n =  8, r = 10, cex = 8, 
                 pch = sample(21:25, size = 8, replace = TRUE), bg = "deeppink")
plot_circ_points(n = 12, r = 8, show_axes = TRUE, show_label = TRUE,
                 cex = 6, pch = 21, lwd = 5, col = "deepskyblue", bg = "gold")

}
\seealso{
Other plot functions: 
\code{\link{plot_charmap}()},
\code{\link{plot_chars}()},
\code{\link{plot_fn}()},
\code{\link{plot_fun}()},
\code{\link{plot_n}()},
\code{\link{plot_text}()},
\code{\link{plot_tiles}()},
\code{\link{theme_clean}()},
\code{\link{theme_ds4psy}()},
\code{\link{theme_empty}()}
}
\concept{plot functions}
