% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsos-s3.R
\name{plot.outlier.test}
\alias{plot.outlier.test}
\title{Plot frequentist test for no adverse shift.}
\usage{
\method{plot}{outlier.test}(x, ...)
}
\arguments{
\item{x}{A \code{outlier.test} result from test of no adverse shift.}

\item{...}{Placeholder to be compatible with S3 method \code{plot}.}
}
\value{
A \pkg{ggplot2} plot with outlier scores and p-value.
}
\description{
Plot frequentist test for no adverse shift.
}
\examples{
\donttest{
set.seed(12345)
os_train <- rnorm(n = 3e2)
os_test <- rnorm(n = 3e2)
test_to_plot <- at_from_os(os_train, os_test)
# Also: pt_from_os(os_train, os_test) for permutation test
plot(test_to_plot)
}

}
\seealso{
Other s3-method: 
\code{\link{plot.outlier.bayes}()},
\code{\link{print.outlier.bayes}()},
\code{\link{print.outlier.test}()}
}
\concept{s3-method}
