% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdstable1.R
\name{rdstable}
\alias{rdstable}
\title{The discrete stable distribution:  random generation}
\usage{
rdstable(n, alpha, lambda = 1)
}
\arguments{
\item{n}{number of random values to return.}

\item{alpha}{tail index parameter \code{alpha} in the interval= \eqn{(0, 1]}}

\item{lambda}{positive location parameter \code{lambda>0}}
}
\value{
returns random variates from \code{DS(alpha,lambda)}. A warning is displayed for invalid parameter values.
}
\description{
Generates random variates from a discrete stable distribution \code{DS(alpha,lambda)}.
}
\examples{
rdstable(10,alpha=1,lambda=1) #this is Poisson
rdstable(10,alpha=0.5,lambda=1) # heavier tail more prone to extremes
rdstable(10,alpha=0.1,lambda=1) # heavier tail more prone to extremes
}
\references{
\insertRef{DEVROYE1993349}{dstabledist}
}
